<?php require_once 'header.php'; ?>
<?php require_once 'navigation.php'; ?>

<?php
if(isset($_POST['form1'])) {
    $valid = 1;
    if(empty($_POST['first_name'])) {
        $valid = 0;
        $error_message .= "First Name can not be empty<br>";
    }
    if(empty($_POST['last_name'])) {
        $valid = 0;
        $error_message .= "Last Name can not be empty<br>";
    }
    if(empty($_POST['username'])) {
        $valid = 0;
        $error_message .= "Username can not be empty<br>";
    }
    if(empty($_POST['email'])) {
        $valid = 0;
        $error_message .= 'Email address can not be empty<br>';
    } else {
        if (filter_var($_POST['email'], FILTER_VALIDATE_EMAIL) === false) {
            $valid = 0;
            $error_message .= 'Email address must be valid<br>';
        } else {
            // current email address that is in the database
            $statement = $pdo->prepare("SELECT * FROM tbl_users WHERE id=?");
            $statement->execute(array($_REQUEST['id']));
            $result = $statement->fetchAll(PDO::FETCH_ASSOC);
            foreach($result as $row) {
                $current_email = $row['email'];
            }
            $statement = $pdo->prepare("SELECT * FROM tbl_users WHERE email=? and email!=?");
            $statement->execute(array($_POST['email'],$current_email));
            $total = $statement->rowCount();
            if($total) {
                $valid = 0;
                $error_message .= 'Email address already exists<br>';
            }
        }
    }

    if($valid == 1) {
        if( empty($_POST['password']) || empty($_POST['re_password']) ) {
            // updating the database
            $statement = $pdo->prepare("UPDATE tbl_users SET username=?, email=?, first_name=?, last_name=? WHERE id=?");
            $statement->execute(array($_POST['username'],$_POST['email'],$_POST['first_name'], $_POST['last_name'],$_REQUEST['id']));
            $success_message = 'User Information is updated successfully.';
        }
    }
    if( !empty($_POST['password']) && !empty($_POST['re_password']) ) {
        if($_POST['password'] != $_POST['re_password']) {
            $valid = 0;
            $error_message .= "Passwords do not match<br>";
        }
    }
    if($valid == 1) {
        // updating the database
        $statement = $pdo->prepare("UPDATE tbl_users SET username=?, password=?, email=?, first_name=?, last_name=? WHERE id=?");
        $statement->execute(array($_POST['username'],md5($_POST['password']),$_POST['email'],$_POST['first_name'],$_POST['last_name'],$_REQUEST['id']));
        $success_message = 'User Information is updated successfully.';
    }
}
?>

<?php
if(!isset($_REQUEST['id'])) {
    header('location: logout.php');
    exit;
} else {
    // Check the id is valid or not
    $statement = $pdo->prepare("SELECT * FROM tbl_users WHERE id=?");
    $statement->execute(array($_REQUEST['id']));
    $total = $statement->rowCount();
    $result = $statement->fetchAll(PDO::FETCH_ASSOC);
    if( $total == 0 || $_REQUEST['id'] == 1 ) {
        header('location: logout.php');
        exit;
    }
}
?>
<?php
$statement = $pdo->prepare("SELECT * FROM tbl_users WHERE id=?");
$statement->execute(array($_REQUEST['id']));
$statement->rowCount();
$result = $statement->fetchAll(PDO::FETCH_ASSOC);
foreach ($result as $row) {
    $first_name = htmlspecialchars($row['first_name'], ENT_QUOTES, 'UTF-8');
    $last_name = htmlspecialchars($row['last_name'], ENT_QUOTES, 'UTF-8');
    $email     = htmlspecialchars($row['email'], ENT_QUOTES, 'UTF-8');
    $username     = htmlspecialchars($row['username'], ENT_QUOTES, 'UTF-8');
}
?>
<div id="wrapper">
    <div class="row">
        <div class="col-md-12">
            <?php if($error_message): ?>
                <div class="callout callout-danger">
                    <h4>Please correct the following errors:</h4>
                    <p>
                        <?php echo $error_message; ?>
                    </p>
                </div>
            <?php endif; ?>

            <?php if($success_message): ?>
                <div class="callout callout-success">
                    <h4>Success:</h4>
                    <p><?php echo $success_message; ?></p>
                </div>
            <?php endif; ?>


            <div class="normalheader transition animated fadeIn small-header">
                <div class="hpanel">
                    <div class="panel-body">
                        <div id="hbreadcrumb" class="pull-right m-t-lg">
                            <ol class="hbreadcrumb breadcrumb">
                                <li><a>Dashboard</a></li>
                                <li>
                                    <span>Users</span>
                                </li>
                                <li class="active">
                                    <span>Edit User</span>
                                </li>
                            </ol>
                        </div>
                        <a href="users.php" class="btn btn-primary btn-sm">View Users</a>
                    </div>
                </div>
            </div>
            <div class="content animate-panel">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="hpanel">
                            <ul class="nav nav-tabs">
                                <li class="active"><a data-toggle="tab" href="#tab-1">Edit Details</a></li>
                            </ul>
                            <div class="tab-content">
                                <div id="tab-1" class="tab-pane active">
                                    <div class="panel-body">
                                        <form method="post" action="" class="form-horizontal" enctype="multipart/form-data">
                                            <div class="form-group">
                                                <label for="" class="col-sm-2 control-label">First Name: <span class="req">*</span></label>
                                                <div class="col-sm-4">
                                                    <input type="text" class="form-control" name="first_name" value="<?php echo $first_name; ?>">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="" class="col-sm-2 control-label">Last Name: <span class="req">*</span></label>
                                                <div class="col-sm-4">
                                                    <input type="text" class="form-control" name="last_name" value="<?php echo $last_name; ?>">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="" class="col-sm-2 control-label">Username: <span class="req">*</span></label>
                                                <div class="col-sm-4">
                                                    <input type="text" class="form-control" name="username" value="<?php echo $username; ?>">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="" class="col-sm-2 control-label">Email Address: <span class="req">*</span></label>
                                                <div class="col-sm-4">
                                                    <input type="email" class="form-control" name="email" value="<?php echo $email; ?>">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="" class="col-sm-2 control-label">New Password: </label>
                                                <div class="col-sm-4">
                                                    <input type="password" placeholder="Leave blank if you don't want to change" class="form-control" name="password">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="" class="col-sm-2 control-label">Retype Password: </label>
                                                <div class="col-sm-4">
                                                    <input type="password" placeholder="Leave blank if you don't want to change" class="form-control" name="re_password">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="col-sm-8 col-sm-offset-2">
                                                    <button class="btn btn-success" type="submit" name="form1">Save</button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div></div></div></div>
            </div>
        </div>
    </div>
    <?php require_once 'footer.php'; ?>
    <!-- Vendor scripts -->
    <script src="vendor/jquery/dist/jquery.min.js"></script>
    <script src="vendor/jquery-ui/jquery-ui.min.js"></script>
    <script src="vendor/slimScroll/jquery.slimscroll.min.js"></script>
    <script src="vendor/bootstrap/dist/js/bootstrap.min.js"></script>
    <script src="vendor/metisMenu/dist/metisMenu.min.js"></script>
    <script src="vendor/iCheck/icheck.min.js"></script>
    <script src="vendor/sparkline/index.js"></script>

    <!-- App scripts -->
    <script src="scripts/homer.js"></script>
    </body>
    </html>